<?php $__env->startSection('content'); ?>
<div class="ambient">
    <span class="orb orb--1"></span>
    <span class="orb orb--2"></span>
    <span class="orb orb--3"></span>
    <span class="spark spark--1"></span>
    <span class="spark spark--2"></span>
    <span class="spark spark--3"></span>
</div>

<div class="stage wish-stage">
    <main class="greeting-card is-revealed wish-page wish-card">
        <p class="badge">Send a wish</p>
        <h1 class="greeting-title">For <?php echo e($greeting->recipient_name); ?></h1>
        <p class="greeting-message">Pick a gift and send a short wish back.</p>

        <?php if($wishSent): ?>
            <p class="wish-sent">Your wish was sent. Thank you.</p>
        <?php endif; ?>

        <form class="wish-form" method="POST" action="<?php echo e(route('greetings.wish', $greeting)); ?>">
            <?php echo csrf_field(); ?>

            <div class="wish-form-grid">
                <div class="wish-form-left">
                    <div class="field">
                        <label for="sender_name">Your name</label>
                        <input id="sender_name" name="sender_name" type="text" value="<?php echo e(old('sender_name')); ?>" required>
                        <?php $__errorArgs = ['sender_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="field-error"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="field">
                        <label for="wish_message">Your wish</label>
                        <textarea id="wish_message" name="message" rows="3" required><?php echo e(old('message')); ?></textarea>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="field-error"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="wish-form-right">
                    <div class="field">
                        <p class="field-label">Choose a gift</p>
                        <div class="gift-grid">
                            <?php $__currentLoopData = $giftOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="gift-option">
                                    <input type="radio" name="gift_choice" value="<?php echo e($value); ?>" <?php echo e(old('gift_choice') === $value ? 'checked' : ''); ?> required>
                                    <span class="gift-card">
                                        <span class="gift-sticker gift-sticker--<?php echo e($value); ?>">
                                            <?php echo $__env->make('greetings.partials.gift-icon', ['gift' => $value], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </span>
                                        <span class="gift-label"><?php echo e($label); ?></span>
                                    </span>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php $__errorArgs = ['gift_choice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="field-error"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="wish-actions">
                <button class="primary-button" type="submit">Send wish</button>
                <a class="secondary-button" href="<?php echo e(route('greetings.final', $greeting)); ?>">Skip for now</a>
            </div>
        </form>
    </main>
</div>

<div class="floor-glow"></div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.greetings', [
    'title' => 'Send a Wish',
    'bodyClass' => 'theme theme--' . $theme,
    'fontUrl' => $fontUrl,
    'bodyStyle' => $bodyStyle,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/gift/resources/views/greetings/wish.blade.php ENDPATH**/ ?>