<?php $__env->startSection('content'); ?>
<div class="studio-shell">
    <header class="studio-header">
        <p class="studio-eyebrow">Template Studio</p>
        <h1>Create a new template</h1>
        <p class="studio-subtitle">Use {name} and {occasion} to personalize the text automatically.</p>
    </header>

    <form class="admin-form" method="POST" action="<?php echo e(route('templates.store')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="field">
            <label for="name">Template name</label>
            <input id="name" name="name" type="text" value="<?php echo e(old('name')); ?>" required>
            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="field-error"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="admin-grid">
            <div class="field">
                <label for="theme">Theme</label>
                <select id="theme" name="theme" required>
                    <?php $__currentLoopData = $themes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e(old('theme', 'spark') === $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['theme'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="field">
                <label for="font_family">Font</label>
                <select id="font_family" name="font_family" required>
                    <?php $__currentLoopData = $fonts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fontName => $fontUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($fontName); ?>" <?php echo e(old('font_family', 'Playfair Display') === $fontName ? 'selected' : ''); ?>><?php echo e($fontName); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['font_family'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="admin-grid">
            <div class="field">
                <label for="intro_title">Intro title</label>
                <input id="intro_title" name="intro_title" type="text" value="<?php echo e(old('intro_title')); ?>" placeholder="Welcome {name}">
                <?php $__errorArgs = ['intro_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="field">
                <label for="intro_subtitle">Intro subtitle</label>
                <input id="intro_subtitle" name="intro_subtitle" type="text" value="<?php echo e(old('intro_subtitle')); ?>" placeholder="Today is {occasion}">
                <?php $__errorArgs = ['intro_subtitle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="admin-grid">
            <div class="field">
                <label for="cake_title">Cake title</label>
                <input id="cake_title" name="cake_title" type="text" value="<?php echo e(old('cake_title')); ?>" placeholder="Lets celebrate">
                <?php $__errorArgs = ['cake_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="field">
                <label for="cake_subtitle">Cake subtitle</label>
                <input id="cake_subtitle" name="cake_subtitle" type="text" value="<?php echo e(old('cake_subtitle')); ?>" placeholder="Make a wish for {name}">
                <?php $__errorArgs = ['cake_subtitle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="admin-grid">
            <div class="field">
                <label for="album_title">Album title</label>
                <input id="album_title" name="album_title" type="text" value="<?php echo e(old('album_title')); ?>" placeholder="Memories together">
                <?php $__errorArgs = ['album_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="field">
                <label for="album_subtitle">Album subtitle</label>
                <input id="album_subtitle" name="album_subtitle" type="text" value="<?php echo e(old('album_subtitle')); ?>" placeholder="A few highlights">
                <?php $__errorArgs = ['album_subtitle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="admin-grid">
            <div class="field">
                <label for="final_title">Final title</label>
                <input id="final_title" name="final_title" type="text" value="<?php echo e(old('final_title')); ?>" placeholder="Happy {occasion}">
                <?php $__errorArgs = ['final_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="field">
                <label for="final_subtitle">Final subtitle</label>
                <input id="final_subtitle" name="final_subtitle" type="text" value="<?php echo e(old('final_subtitle')); ?>" placeholder="With love for {name}">
                <?php $__errorArgs = ['final_subtitle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="field">
            <label for="video">Background video (MP4, max 10 MB)</label>
            <input id="video" name="video" type="file" accept="video/mp4">
            <?php $__errorArgs = ['video'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="field-error"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="admin-actions">
            <button class="primary-button" type="submit">Create template</button>
            <a class="secondary-button" href="<?php echo e(route('templates.index')); ?>">Cancel</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.greetings', [
    'title' => 'Create Template',
    'bodyClass' => 'studio theme--studio',
    'showNav' => true,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/gift/resources/views/templates/create.blade.php ENDPATH**/ ?>