<?php $__env->startSection('content'); ?>
<div class="studio-shell">
    <header class="studio-header">
        <p class="studio-eyebrow">QR Wish Studio</p>
        <h1>Create a wish that becomes a scannable card.</h1>
        <p class="studio-subtitle">Choose a template, pick an occasion, and generate a QR code you can send to anyone.</p>
    </header>

    <div class="studio-grid">
        <form class="studio-form" method="POST" action="<?php echo e(route('greetings.store')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="field">
                <label for="recipient_name">Recipient name</label>
                <input id="recipient_name" name="recipient_name" type="text" value="<?php echo e(old('recipient_name')); ?>" required>
                <?php $__errorArgs = ['recipient_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="field">
                <label for="occasion">Occasion</label>
                <select id="occasion" name="occasion" required>
                    <option value="" disabled <?php echo e(old('occasion') ? '' : 'selected'); ?>>Select an occasion</option>
                    <?php $__currentLoopData = $occasions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e(old('occasion') === $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['occasion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="field">
                <label for="template_id">Template</label>
                <select id="template_id" name="template_id">
                    <option value="" <?php echo e(old('template_id') ? '' : 'selected'); ?>>Default design</option>
                    <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($template->id); ?>" <?php echo e((string) old('template_id') === (string) $template->id ? 'selected' : ''); ?>><?php echo e($template->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <p class="field-hint">Templates control video, fonts, and step text.</p>
                <?php $__errorArgs = ['template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="field">
                <label for="style">Style</label>
                <select id="style" name="style" required>
                    <?php $__currentLoopData = $styles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e(old('style', 'spark') === $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['style'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="field">
                <label for="message">Custom message (optional)</label>
                <textarea id="message" name="message" rows="4" placeholder="Add a short note..."><?php echo e(old('message')); ?></textarea>
                <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="field">
                <label for="photos">Photo album (up to 12 photos)</label>
                <input id="photos" name="photos[]" type="file" multiple accept="image/*">
                <p class="field-hint">Add up to 12 photos to show on the album step.</p>
                <?php $__errorArgs = ['photos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php $__errorArgs = ['photos.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="field-error"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <button class="primary-button" type="submit">Generate QR Code</button>
        </form>

        <aside class="studio-preview">
            <div class="preview-card">
                <p class="preview-title">What happens next</p>
                <ol class="preview-steps">
                    <li>We create your greeting and save the QR code.</li>
                    <li>The experience plays: intro, cake, wish, album, and final message.</li>
                    <li>Wishes sent back appear on your dashboard.</li>
                </ol>
                <p class="preview-note">Tip: set <code>APP_URL</code> in <code>.env</code> so the QR points to your real domain.</p>
            </div>
        </aside>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.greetings', [
    'title' => 'Create a QR Wish',
    'bodyClass' => 'studio theme--studio',
    'showNav' => true,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/gift/resources/views/greetings/create.blade.php ENDPATH**/ ?>