<?php $__env->startSection('content'); ?>
<div class="studio-shell">
    <header class="studio-header">
        <p class="studio-eyebrow">Admin</p>
        <h1>Manage users and access</h1>
        <p class="studio-subtitle">Create accounts and assign roles or permissions.</p>
    </header>

    <div class="admin-actions">
        <a class="primary-button" href="<?php echo e(route('admin.users.create')); ?>">Create user</a>
    </div>

    <div class="admin-table">
        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Roles</th>
                    <th>Permissions</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($user->name); ?></td>
                        <td><?php echo e($user->email); ?></td>
                        <td><?php echo e($user->roles->pluck('name')->implode(', ') ?: '-'); ?></td>
                        <td><?php echo e($user->permissions->pluck('name')->implode(', ') ?: '-'); ?></td>
                        <td>
                            <a class="ghost-button" href="<?php echo e(route('admin.users.edit', $user)); ?>">Edit</a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5">No users found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.greetings', [
    'title' => 'Manage Users',
    'bodyClass' => 'studio theme--studio',
    'showNav' => true,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/gift/resources/views/admin/users/index.blade.php ENDPATH**/ ?>