<?php $__env->startSection('content'); ?>
<div class="ambient">
    <span class="orb orb--1"></span>
    <span class="orb orb--2"></span>
    <span class="orb orb--3"></span>
    <span class="spark spark--1"></span>
    <span class="spark spark--2"></span>
    <span class="spark spark--3"></span>
</div>

<!-- Confetti container for celebration -->
<div class="confetti-container" data-confetti hidden aria-hidden="true">
    <?php for($i = 1; $i <= 50; $i++): ?>
    <span class="confetti confetti--<?php echo e($i % 8 + 1); ?>"></span>
    <?php endfor; ?>
</div>

<!-- Balloon rain for celebration -->
<div class="balloon-rain gift-balloons" data-gift-balloons hidden aria-hidden="true">
    <span class="balloon balloon--1"></span>
    <span class="balloon balloon--2"></span>
    <span class="balloon balloon--3"></span>
    <span class="balloon balloon--4"></span>
    <span class="balloon balloon--5"></span>
    <span class="balloon balloon--6"></span>
    <span class="balloon balloon--7"></span>
    <span class="balloon balloon--8"></span>
    <span class="balloon balloon--9"></span>
    <span class="balloon balloon--10"></span>
    <span class="balloon balloon--11"></span>
    <span class="balloon balloon--12"></span>
</div>

<div class="stage">
    <main class="greeting-card is-revealed final-card">
        <p class="badge"><?php echo e($occasionLabel); ?></p>
        <h1 class="greeting-title"><?php echo e($finalTitle); ?></h1>
        <p class="greeting-message"><?php echo e($finalSubtitle); ?></p>

        <div class="gift-stage" data-gift-stage>
            <div class="gift-box" data-gift-box>
                <span class="gift-lid"></span>
                <span class="gift-base"></span>
                <span class="gift-ribbon"></span>
            </div>
            <button class="primary-button" type="button" data-open-gift>Open the gift</button>
        </div>

        <p class="final-message" data-final-message hidden><?php echo e($message); ?></p>

        <div class="album-actions">
            <a class="secondary-button" href="<?php echo e(route('greetings.intro', $greeting)); ?>">Replay</a>
        </div>
    </main>
</div>

<!-- Gift Popup Modal -->
<div class="gift-popup-overlay" data-gift-popup hidden>
    <div class="gift-popup">
        <div class="gift-popup-sparkle"></div>
        <div class="gift-popup-content">
            <h2 class="gift-popup-title">🎉 Congratulations! 🎉</h2>

            <?php
                $giftImages = [
                    'ring' => 'ring.jpeg',
                    'watch' => 'watch.jpeg',
                    'necklace' => 'necklace.jpg',
                    'bracelet' => 'bracelet.jpeg',
                    'perfume' => 'perfume.jpeg',
                    'flowers' => 'flowers.jpeg',
                    'chocolate_box' => 'chocolatebox.jpeg',
                    'teddy_bear' => 'teddy_bear.jpeg',
                ];
                $giftImage = $giftImages[$giftChoice] ?? null;
            ?>

            <?php if($giftImage): ?>
                <div class="gift-popup-image-wrap">
                    <img class="gift-popup-image" src="<?php echo e(asset($giftImage)); ?>" alt="<?php echo e($giftLabel); ?>">
                </div>
            <?php else: ?>
                <div class="gift-popup-icon gift-sticker--<?php echo e($giftChoice); ?>">
                    <?php echo $__env->make('greetings.partials.gift-icon', ['gift' => $giftChoice], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            <?php endif; ?>

            <p class="gift-popup-label">You received a</p>
            <p class="gift-popup-name"><?php echo e($giftLabel); ?></p>
            <p class="gift-popup-cheer" data-cheer-text><?php echo e($occasionLabel); ?>! Enjoy your special gift!</p>
            <button class="primary-button gift-popup-collect" type="button" data-collect-gift>Collect Gift</button>
        </div>
    </div>
</div>

<!-- Envelope with Praise Message -->
<div class="envelope-overlay" data-envelope-overlay hidden>
    <div class="envelope-scene">
        <!-- Praise Card (hidden initially, appears above envelope when opened) -->
        <div class="praise-card-floating" data-praise-card hidden>
            <p class="praise-icon">💌</p>
            <h3 class="praise-title">A Special Message</h3>
            <p class="praise-text"><?php echo e($message ?: 'Wishing you all the happiness and joy on this special occasion. May your day be filled with love, laughter, and beautiful memories!'); ?></p>
            <p class="praise-signature">With love ❤️</p>
        </div>

        <!-- Envelope Container -->
        <div class="envelope-container" data-envelope-container>
            <div class="envelope" data-envelope>
                <div class="envelope-back"></div>
                <div class="envelope-front"></div>
                <div class="envelope-flap" data-envelope-flap></div>
            </div>
            <p class="envelope-hint" data-envelope-hint>Tap the envelope to open</p>
            <button class="primary-button envelope-open-btn" type="button" data-open-envelope>Open Envelope</button>
        </div>

        <div class="envelope-actions" data-envelope-actions hidden>
            <a class="primary-button" href="<?php echo e(route('greetings.intro', $greeting)); ?>">View Again</a>
        </div>
    </div>
</div>

<!-- Goodbye Overlay -->
<div class="goodbye-overlay" data-goodbye-overlay hidden>
    <div class="goodbye-content">
        <div class="goodbye-stars">
            <span class="goodbye-star">✨</span>
            <span class="goodbye-star">⭐</span>
            <span class="goodbye-star">✨</span>
        </div>
        <h2 class="goodbye-title">Goodbye!</h2>
        <p class="goodbye-text">Thank you for celebrating with us</p>
        <p class="goodbye-wish">Have a wonderful day! 🎉</p>
        <a class="secondary-button goodbye-btn" href="<?php echo e(route('greetings.intro', $greeting)); ?>">Start Over</a>
    </div>
</div>

<!-- Step Indicator -->
<div class="step-indicator" data-step-indicator>
    <span class="step-dot step-dot--active" data-step="1"></span>
    <span class="step-dot" data-step="2"></span>
    <span class="step-dot" data-step="3"></span>
    <span class="step-dot" data-step="4"></span>
</div>

<div class="floor-glow"></div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const stage = document.querySelector('[data-gift-stage]');
        const openButton = document.querySelector('[data-open-gift]');
        const giftPopup = document.querySelector('[data-gift-popup]');
        const confetti = document.querySelector('[data-confetti]');
        const giftBalloons = document.querySelector('[data-gift-balloons]');
        const collectButton = document.querySelector('[data-collect-gift]');
        const envelopeOverlay = document.querySelector('[data-envelope-overlay]');
        const envelope = document.querySelector('[data-envelope]');
        const praiseCard = document.querySelector('[data-praise-card]');
        const openEnvelopeBtn = document.querySelector('[data-open-envelope]');
        const envelopeHint = document.querySelector('[data-envelope-hint]');
        const envelopeActions = document.querySelector('[data-envelope-actions]');
        const goodbyeOverlay = document.querySelector('[data-goodbye-overlay]');
        const finalMessage = document.querySelector('[data-final-message]');
        const giftBox = document.querySelector('[data-gift-box]');
        const stepDots = document.querySelectorAll('[data-step]');

        const setActiveStep = (step) => {
            stepDots.forEach(dot => {
                dot.classList.remove('step-dot--active');
                if (parseInt(dot.dataset.step) === step) {
                    dot.classList.add('step-dot--active');
                }
            });
        };

        if (!stage || !openButton) {
            return;
        }

        // Step 1: Initial state (gift box)
        setActiveStep(1);

        // Open gift and show popup
        openButton.addEventListener('click', () => {
            stage.classList.add('is-open');
            openButton.disabled = true;
            openButton.hidden = true;

            // Show confetti and balloons
            if (confetti) {
                confetti.hidden = false;
            }
            if (giftBalloons) {
                giftBalloons.hidden = false;
            }

            // Show gift popup after box animation
            setTimeout(() => {
                if (giftPopup) {
                    giftPopup.hidden = false;
                    setTimeout(() => {
                        giftPopup.classList.add('is-visible');
                    }, 50);
                }
                // Step 2: Gift revealed
                setActiveStep(2);
            }, 600);

            if (finalMessage) {
                finalMessage.hidden = false;
            }
        });

        // Collect gift - show envelope
        if (collectButton) {
            collectButton.addEventListener('click', () => {
                if (giftPopup) {
                    giftPopup.classList.remove('is-visible');
                    setTimeout(() => {
                        giftPopup.hidden = true;
                    }, 400);
                }

                if (confetti) {
                    confetti.hidden = true;
                }

                if (giftBalloons) {
                    giftBalloons.hidden = true;
                }

                if (giftBox) {
                    giftBox.hidden = true;
                }

                // Show envelope
                setTimeout(() => {
                    if (envelopeOverlay) {
                        envelopeOverlay.hidden = false;
                        setTimeout(() => {
                            envelopeOverlay.classList.add('is-visible');
                        }, 50);
                    }
                    // Step 3: Envelope
                    setActiveStep(3);
                }, 300);
            });
        }

        // Open envelope
        const openEnvelope = () => {
            if (envelope && !envelope.classList.contains('is-open')) {
                envelope.classList.add('is-open');
                if (openEnvelopeBtn) {
                    openEnvelopeBtn.hidden = true;
                }
                if (envelopeHint) {
                    envelopeHint.hidden = true;
                }

                // Fade envelope container
                const envelopeContainer = document.querySelector('[data-envelope-container]');
                if (envelopeContainer) {
                    setTimeout(() => {
                        envelopeContainer.classList.add('is-faded');
                    }, 300);
                }

                // Show praise card above envelope
                setTimeout(() => {
                    if (praiseCard) {
                        praiseCard.hidden = false;
                        // Force reflow for animation
                        praiseCard.offsetHeight;
                        praiseCard.classList.add('is-visible');
                    }
                }, 500);

                // Show actions after card appears
                setTimeout(() => {
                    if (envelopeActions) {
                        envelopeActions.hidden = false;
                    }
                }, 1200);
            }
        };

        if (openEnvelopeBtn) {
            openEnvelopeBtn.addEventListener('click', openEnvelope);
        }

        if (envelope) {
            envelope.addEventListener('click', openEnvelope);
        }

        // View Again button shows goodbye
        const viewAgainBtn = document.querySelector('[data-envelope-actions] .primary-button');
        if (viewAgainBtn) {
            viewAgainBtn.addEventListener('click', (e) => {
                e.preventDefault();

                // Hide envelope
                if (envelopeOverlay) {
                    envelopeOverlay.classList.remove('is-visible');
                    setTimeout(() => {
                        envelopeOverlay.hidden = true;
                    }, 400);
                }

                // Show goodbye
                setTimeout(() => {
                    if (goodbyeOverlay) {
                        goodbyeOverlay.hidden = false;
                        setTimeout(() => {
                            goodbyeOverlay.classList.add('is-visible');
                        }, 50);
                    }
                    // Step 4: Goodbye
                    setActiveStep(4);
                }, 400);
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.greetings', [
    'title' => $occasionLabel . ' for ' . $greeting->recipient_name,
    'bodyClass' => 'theme theme--' . $theme,
    'fontUrl' => $fontUrl,
    'bodyStyle' => $bodyStyle,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/gift/resources/views/greetings/final.blade.php ENDPATH**/ ?>