<?php $__env->startSection('content'); ?>
<div class="studio-shell">
    <header class="studio-header">
        <p class="studio-eyebrow">Template Studio</p>
        <h1>Create and manage your greeting templates</h1>
        <p class="studio-subtitle">Design the full experience: video intro, cake, wish, album, and final message.</p>
    </header>

    <div class="admin-actions">
        <a class="primary-button" href="<?php echo e(route('templates.create')); ?>">New template</a>
    </div>

    <div class="admin-table">
        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Theme</th>
                    <th>Font</th>
                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'admin')): ?>
                        <th>Owner</th>
                    <?php endif; ?>
                    <th>Video</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($template->name); ?></td>
                        <td><?php echo e(ucfirst($template->theme)); ?></td>
                        <td><?php echo e($template->font_family); ?></td>
                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'admin')): ?>
                            <td><?php echo e($template->user->name ?? '-'); ?></td>
                        <?php endif; ?>
                        <td><?php echo e($template->video_path ? 'Yes' : 'No'); ?></td>
                        <td class="table-actions">
                            <a class="ghost-button" href="<?php echo e(route('templates.edit', $template)); ?>">Edit</a>
                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'admin')): ?>
                                <form method="POST" action="<?php echo e(route('templates.destroy', $template)); ?>" onsubmit="return confirm('Delete this template?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="ghost-button" type="submit">Delete</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->hasRole('admin') ? 6 : 5); ?>">No templates yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.greetings', [
    'title' => 'Template Studio',
    'bodyClass' => 'studio theme--studio',
    'showNav' => true,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/gift/resources/views/templates/index.blade.php ENDPATH**/ ?>