<?php $__env->startSection('content'); ?>
<div class="studio-shell">
    <header class="studio-header">
        <p class="studio-eyebrow">Dashboard</p>
        <h1>Your wishes and greetings</h1>
        <p class="studio-subtitle">See the wishes friends and family sent back to you.</p>
    </header>

    <div class="dashboard-grid">
        <?php $__empty_1 = true; $__currentLoopData = $greetings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $greeting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <div>
                        <p class="dashboard-title"><?php echo e($greeting->recipient_name); ?></p>
                        <p class="dashboard-meta"><?php echo e(ucfirst(str_replace('_', ' ', $greeting->occasion))); ?> - <?php echo e(ucfirst($greeting->style)); ?></p>
                    </div>
                    <a class="ghost-button" href="<?php echo e(route('greetings.show', $greeting)); ?>" target="_blank" rel="noopener">View</a>
                </div>

                <div class="wish-list">
                    <?php $__empty_2 = true; $__currentLoopData = $greeting->wishes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wish): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                        <div class="wish-item">
                            <p class="wish-name"><?php echo e($wish->sender_name); ?></p>
                            <p class="wish-message"><?php echo e($wish->message); ?></p>
                            <p class="wish-time"><?php echo e($wish->created_at->diffForHumans()); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                        <p class="wish-empty">No wishes yet.</p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="wish-empty">You have not created any greetings yet.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.greetings', [
    'title' => 'Your Dashboard',
    'bodyClass' => 'studio theme--studio',
    'showNav' => true,
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/gift/resources/views/dashboard/index.blade.php ENDPATH**/ ?>